/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.util.HashMap;
import java.util.Map;
import org.jboss.ejb.client.remoting.ProtocolV1ClassTable;
import org.jboss.ejb.client.remoting.ProtocolV1ObjectTable;
import org.jboss.ejb.client.remoting.SecurityActions;
import org.jboss.marshalling.AbstractClassResolver;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.remoting3.MessageInputStream;

abstract class ProtocolMessageHandler {
    ProtocolMessageHandler() {
    }

    protected abstract void processMessage(MessageInputStream var1) throws IOException;

    protected Map<String, Object> readAttachments(ObjectInput input) throws IOException, ClassNotFoundException {
        int numAttachments = input.readByte();
        if (numAttachments == 0) {
            return null;
        }
        HashMap<String, Object> attachments = new HashMap<String, Object>(numAttachments);
        for (int i = 0; i < numAttachments; ++i) {
            String key = (String)input.readObject();
            Object val = input.readObject();
            attachments.put(key, val);
        }
        return attachments;
    }

    short getInvocationId(DataInput input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Cannot read from null input");
        }
        return input.readShort();
    }

    protected Unmarshaller prepareForUnMarshalling(MarshallerFactory marshallerFactory, final DataInput dataInput) throws IOException {
        Unmarshaller unmarshaller = this.getUnMarshaller(marshallerFactory);
        InputStream is = new InputStream(){

            @Override
            public int read() throws IOException {
                try {
                    byte b = dataInput.readByte();
                    return b & 0xFF;
                }
                catch (EOFException eof) {
                    return -1;
                }
            }
        };
        ByteInput byteInput = Marshalling.createByteInput((InputStream)is);
        unmarshaller.start(byteInput);
        return unmarshaller;
    }

    private Unmarshaller getUnMarshaller(MarshallerFactory marshallerFactory) throws IOException {
        MarshallingConfiguration marshallingConfiguration = new MarshallingConfiguration();
        marshallingConfiguration.setVersion(2);
        marshallingConfiguration.setClassTable((ClassTable)ProtocolV1ClassTable.INSTANCE);
        marshallingConfiguration.setObjectTable((ObjectTable)ProtocolV1ObjectTable.INSTANCE);
        marshallingConfiguration.setClassResolver((ClassResolver)TCCLClassResolver.INSTANCE);
        return marshallerFactory.createUnmarshaller(marshallingConfiguration);
    }

    private static final class TCCLClassResolver
    extends AbstractClassResolver {
        static TCCLClassResolver INSTANCE = new TCCLClassResolver();

        private TCCLClassResolver() {
        }

        protected ClassLoader getClassLoader() {
            return SecurityActions.getContextClassLoader();
        }
    }
}

