/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.ejb.client.ClusterNodeManager;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.remoting.ClusterNode;
import org.jboss.ejb.client.remoting.IoFutureHelper;
import org.jboss.ejb.client.remoting.RemotingConnectionEJBReceiver;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

class RemotingConnectionClusterNodeManager
implements ClusterNodeManager {
    private static final Logger logger = Logger.getLogger(RemotingConnectionClusterNodeManager.class);
    private final String clusterName;
    private final ClusterNode clusterNode;
    private final Endpoint endpoint;
    private final EJBClientConfiguration ejbClientConfiguration;

    RemotingConnectionClusterNodeManager(String clusterName, ClusterNode clusterNode, Endpoint endpoint, EJBClientConfiguration ejbClientConfiguration) {
        this.clusterName = clusterName;
        this.clusterNode = clusterNode;
        this.endpoint = endpoint;
        this.ejbClientConfiguration = ejbClientConfiguration;
    }

    @Override
    public String getNodeName() {
        return this.clusterNode.getNodeName();
    }

    @Override
    public EJBReceiver getEJBReceiver() {
        Connection connection;
        if (!this.clusterNode.isDestinationResolved()) {
            logger.error((Object)("Cannot create a EJB receiver for " + this.clusterNode + " since there was no match for a target destination"));
            return null;
        }
        try {
            connection = this.createConnection();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create a connection for cluster node " + this.clusterNode + " in cluster " + this.clusterName);
        }
        return new RemotingConnectionEJBReceiver(connection);
    }

    private Connection createConnection() throws IOException, URISyntaxException {
        URI connectionURI = new URI("remote://" + this.clusterNode.getDestinationAddress() + ":" + this.clusterNode.getDestinationPort());
        if (this.ejbClientConfiguration != null) {
            EJBClientConfiguration.ClusterConfiguration clusterConfiguration = this.ejbClientConfiguration.getClusterConfiguration(this.clusterName);
            if (clusterConfiguration == null) {
                IoFuture futureConnection = this.endpoint.connect(connectionURI, OptionMap.EMPTY, this.ejbClientConfiguration.getCallbackHandler());
                return (Connection)IoFutureHelper.get(futureConnection, 5000L, TimeUnit.MILLISECONDS);
            }
            IoFuture futureConnection = this.endpoint.connect(connectionURI, clusterConfiguration.getConnectionCreationOptions(), clusterConfiguration.getCallbackHandler());
            return (Connection)IoFutureHelper.get(futureConnection, clusterConfiguration.getConnectionTimeout(), TimeUnit.MILLISECONDS);
        }
        return this.createConnectionUsingDefaults();
    }

    private Connection createConnectionUsingDefaults() throws IOException, URISyntaxException {
        URI connectionURI = new URI("remote://" + this.clusterNode.getDestinationAddress() + ":" + this.clusterNode.getDestinationPort());
        IoFuture futureConnection = this.endpoint.connect(connectionURI, OptionMap.EMPTY, (CallbackHandler)new AnonymousCallbackHandler());
        return (Connection)IoFutureHelper.get(futureConnection, 5000L, TimeUnit.MILLISECONDS);
    }

    private class AnonymousCallbackHandler
    implements CallbackHandler {
        private AnonymousCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (!(current instanceof NameCallback)) {
                    throw new UnsupportedCallbackException(current);
                }
                NameCallback ncb = (NameCallback)current;
                ncb.setName("anonymous");
            }
        }
    }
}

