/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.FailoverEventListener;
import org.hornetq.api.core.client.FailoverEventType;
import org.hornetq.api.core.client.SessionFailureListener;
import org.hornetq.core.client.impl.ClientSessionInternal;
import org.hornetq.core.version.Version;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.hornetq.jms.client.HornetQConnectionMetaData;
import org.hornetq.jms.client.HornetQDestination;
import org.hornetq.jms.client.HornetQJMSClientLogger;
import org.hornetq.jms.client.HornetQSession;
import org.hornetq.jms.client.HornetQXASession;
import org.hornetq.jms.client.JMSExceptionHelper;
import org.hornetq.utils.ConcurrentHashSet;
import org.hornetq.utils.UUIDGenerator;
import org.hornetq.utils.VersionLoader;

public class HornetQConnection
implements TopicConnection,
QueueConnection {
    public static final int TYPE_GENERIC_CONNECTION = 0;
    public static final int TYPE_QUEUE_CONNECTION = 1;
    public static final int TYPE_TOPIC_CONNECTION = 2;
    public static final String EXCEPTION_FAILOVER = "FAILOVER";
    public static final String EXCEPTION_DISCONNECT = "DISCONNECT";
    public static final SimpleString CONNECTION_ID_PROPERTY_NAME = new SimpleString("__HQ_CID");
    private final int connectionType;
    private final Set<HornetQSession> sessions = new ConcurrentHashSet();
    private final Set<SimpleString> tempQueues = new ConcurrentHashSet();
    private volatile boolean hasNoLocal;
    private volatile ExceptionListener exceptionListener;
    private volatile FailoverEventListener failoverEventListener;
    private volatile boolean justCreated = true;
    private volatile ConnectionMetaData metaData;
    private volatile boolean closed;
    private volatile boolean started;
    private String clientID;
    private final ClientSessionFactory sessionFactory;
    private final SimpleString uid;
    private final String username;
    private final String password;
    private final SessionFailureListener listener = new JMSFailureListener(this);
    private final FailoverEventListener failoverListener = new FailoverEventListenerImpl(this);
    private final Version thisVersion;
    private final int dupsOKBatchSize;
    private final int transactionBatchSize;
    private ClientSession initialSession;
    private final Exception creationStack;
    private HornetQConnectionFactory factoryReference;

    public HornetQConnection(String username, String password, int connectionType, String clientID, int dupsOKBatchSize, int transactionBatchSize, ClientSessionFactory sessionFactory) {
        this.username = username;
        this.password = password;
        this.connectionType = connectionType;
        this.clientID = clientID;
        this.sessionFactory = sessionFactory;
        this.uid = UUIDGenerator.getInstance().generateSimpleStringUUID();
        this.thisVersion = VersionLoader.getVersion();
        this.dupsOKBatchSize = dupsOKBatchSize;
        this.transactionBatchSize = transactionBatchSize;
        this.creationStack = new Exception();
    }

    public Session createNonXASession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        return this.createSessionInternal(false, transacted, acknowledgeMode, 0);
    }

    public Session createNonXATopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        return this.createSessionInternal(false, transacted, acknowledgeMode, 2);
    }

    public Session createNonXAQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        return this.createSessionInternal(false, transacted, acknowledgeMode, 1);
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        return this.createSessionInternal(false, transacted, acknowledgeMode, 0);
    }

    public String getClientID() throws JMSException {
        this.checkClosed();
        return this.clientID;
    }

    public void setClientID(String clientID) throws JMSException {
        block6: {
            this.checkClosed();
            if (this.clientID != null) {
                throw new IllegalStateException("Client id has already been set");
            }
            if (!this.justCreated) {
                throw new IllegalStateException("setClientID can only be called directly after the connection is created");
            }
            try {
                this.initialSession.addUniqueMetaData("jms-client-id", clientID);
            }
            catch (HornetQException e) {
                if (e.getType() != HornetQExceptionType.DUPLICATE_METADATA) break block6;
                throw new IllegalStateException("clientID=" + clientID + " was already set into another connection");
            }
        }
        this.clientID = clientID;
        try {
            this.addSessionMetaData(this.initialSession);
        }
        catch (HornetQException e) {
            JMSException ex = new JMSException("Internal error setting metadata jms-client-id");
            ex.setLinkedException((Exception)((Object)e));
            throw ex;
        }
        this.justCreated = false;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        this.checkClosed();
        this.justCreated = false;
        if (this.metaData == null) {
            this.metaData = new HornetQConnectionMetaData(this.thisVersion);
        }
        return this.metaData;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.checkClosed();
        this.justCreated = false;
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.checkClosed();
        this.exceptionListener = listener;
        this.justCreated = false;
    }

    public synchronized void start() throws JMSException {
        this.checkClosed();
        for (HornetQSession session : this.sessions) {
            session.start();
        }
        this.justCreated = false;
        this.started = true;
    }

    public synchronized void signalStopToAllSessions() {
        for (HornetQSession session : this.sessions) {
            ClientSession coreSession = session.getCoreSession();
            if (!(coreSession instanceof ClientSessionInternal)) continue;
            ClientSessionInternal internalSession = (ClientSessionInternal)coreSession;
            internalSession.setStopSignal();
        }
    }

    public synchronized void stop() throws JMSException {
        this.checkClosed();
        for (HornetQSession session : this.sessions) {
            session.stop();
        }
        this.justCreated = false;
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void close() throws JMSException {
        if (this.closed) {
            return;
        }
        this.sessionFactory.close();
        try {
            for (HornetQSession session : new HashSet<HornetQSession>(this.sessions)) {
                session.close();
            }
            try {
                if (!this.tempQueues.isEmpty()) {
                    for (SimpleString queueName : this.tempQueues) {
                        if (this.initialSession.isClosed()) continue;
                        try {
                            this.initialSession.deleteQueue(queueName);
                        }
                        catch (HornetQException hornetQException) {}
                    }
                }
            }
            finally {
                if (this.initialSession != null) {
                    this.initialSession.close();
                }
            }
            this.closed = true;
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        this.checkTempQueues(destination);
        return null;
    }

    private void checkTempQueues(Destination destination) throws JMSException {
        HornetQDestination jbdest = (HornetQDestination)destination;
        if (jbdest.isTemporary() && !this.containsTemporaryQueue(jbdest.getSimpleAddress())) {
            throw new JMSException("Can not create consumer for temporary destination " + destination + " from another JMS connection");
        }
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        if (this.connectionType == 1) {
            String msg = "Cannot create a durable connection consumer on a QueueConnection";
            throw new IllegalStateException(msg);
        }
        this.checkTempQueues((Destination)topic);
        return null;
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        return this.createSessionInternal(false, transacted, acknowledgeMode, 1);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        this.checkTempQueues((Destination)queue);
        return null;
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        return this.createSessionInternal(false, transacted, acknowledgeMode, 2);
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        this.checkTempQueues((Destination)topic);
        return null;
    }

    public void setFailoverListener(FailoverEventListener listener) throws JMSException {
        this.checkClosed();
        this.justCreated = false;
        this.failoverEventListener = listener;
    }

    public FailoverEventListener getFailoverListener() throws JMSException {
        this.checkClosed();
        this.justCreated = false;
        return this.failoverEventListener;
    }

    public void addTemporaryQueue(SimpleString queueAddress) {
        this.tempQueues.add(queueAddress);
    }

    public void removeTemporaryQueue(SimpleString queueAddress) {
        this.tempQueues.remove(queueAddress);
    }

    public boolean containsTemporaryQueue(SimpleString queueAddress) {
        return this.tempQueues.contains(queueAddress);
    }

    public boolean hasNoLocal() {
        return this.hasNoLocal;
    }

    public void setHasNoLocal() {
        this.hasNoLocal = true;
    }

    public SimpleString getUID() {
        return this.uid;
    }

    public void removeSession(HornetQSession session) {
        this.sessions.remove(session);
    }

    public ClientSession getInitialSession() {
        return this.initialSession;
    }

    protected final void finalize() throws Throwable {
        if (!this.closed) {
            HornetQJMSClientLogger.LOGGER.connectionLeftOpen(this.creationStack);
            this.close();
        }
    }

    protected boolean isXA() {
        return false;
    }

    protected final HornetQSession createSessionInternal(boolean isXA, boolean transacted, int acknowledgeMode, int type) throws JMSException {
        if (transacted) {
            acknowledgeMode = 0;
        }
        try {
            ClientSession session;
            if (acknowledgeMode == 0) {
                session = this.sessionFactory.createSession(this.username, this.password, isXA, false, false, this.sessionFactory.getServerLocator().isPreAcknowledge(), this.transactionBatchSize);
            } else if (acknowledgeMode == 1) {
                session = this.sessionFactory.createSession(this.username, this.password, isXA, true, true, this.sessionFactory.getServerLocator().isPreAcknowledge(), 0);
            } else if (acknowledgeMode == 3) {
                session = this.sessionFactory.createSession(this.username, this.password, isXA, true, true, this.sessionFactory.getServerLocator().isPreAcknowledge(), this.dupsOKBatchSize);
            } else if (acknowledgeMode == 2) {
                session = this.sessionFactory.createSession(this.username, this.password, isXA, true, false, this.sessionFactory.getServerLocator().isPreAcknowledge(), this.transactionBatchSize);
            } else if (acknowledgeMode == 101) {
                session = this.sessionFactory.createSession(this.username, this.password, isXA, true, false, false, this.transactionBatchSize);
            } else if (acknowledgeMode == 100) {
                session = this.sessionFactory.createSession(this.username, this.password, isXA, true, false, true, this.transactionBatchSize);
            } else {
                throw new IllegalArgumentException("Invalid ackmode: " + acknowledgeMode);
            }
            this.justCreated = false;
            session.addFailureListener(this.listener);
            session.addFailoverListener(this.failoverListener);
            HornetQSession jbs = this.createHQSession(isXA, transacted, acknowledgeMode, session, type);
            this.sessions.add(jbs);
            if (this.started) {
                session.start();
            }
            this.addSessionMetaData(session);
            return jbs;
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    protected HornetQSession createHQSession(boolean isXA, boolean transacted, int acknowledgeMode, ClientSession session, int type) {
        if (isXA) {
            return new HornetQXASession(this, transacted, true, acknowledgeMode, session, type);
        }
        return new HornetQSession(this, transacted, false, acknowledgeMode, session, type);
    }

    protected final void checkClosed() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Connection is closed");
        }
    }

    public void authorize() throws JMSException {
        try {
            this.initialSession = this.sessionFactory.createSession(this.username, this.password, false, false, false, false, 0);
            this.addSessionMetaData(this.initialSession);
            this.initialSession.addFailureListener(this.listener);
            this.initialSession.addFailoverListener(this.failoverListener);
        }
        catch (HornetQException me) {
            throw JMSExceptionHelper.convertFromHornetQException(me);
        }
    }

    private void addSessionMetaData(ClientSession session) throws HornetQException {
        session.addMetaData("jms-session", "");
        if (this.clientID != null) {
            session.addMetaData("jms-client-id", this.clientID);
        }
    }

    public void setReference(HornetQConnectionFactory factory) {
        this.factoryReference = factory;
    }

    private static class FailoverEventListenerImpl
    implements FailoverEventListener {
        private final WeakReference<HornetQConnection> connectionRef;

        FailoverEventListenerImpl(HornetQConnection connection) {
            this.connectionRef = new WeakReference<HornetQConnection>(connection);
        }

        public void failoverEvent(final FailoverEventType eventType) {
            block4: {
                HornetQConnection conn = (HornetQConnection)this.connectionRef.get();
                if (conn != null) {
                    try {
                        final FailoverEventListener failoverListener = conn.getFailoverListener();
                        if (failoverListener != null) {
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    failoverListener.failoverEvent(eventType);
                                }
                            }).start();
                        }
                    }
                    catch (JMSException e) {
                        if (conn.closed) break block4;
                        HornetQJMSClientLogger.LOGGER.errorCallingFailoverListener((Exception)((Object)e));
                    }
                }
            }
        }
    }

    private static class JMSFailureListener
    implements SessionFailureListener {
        private final WeakReference<HornetQConnection> connectionRef;

        JMSFailureListener(HornetQConnection connection) {
            this.connectionRef = new WeakReference<HornetQConnection>(connection);
        }

        public synchronized void connectionFailed(HornetQException me, boolean failedOver) {
            block5: {
                if (me == null) {
                    return;
                }
                HornetQConnection conn = (HornetQConnection)this.connectionRef.get();
                if (conn != null) {
                    try {
                        final ExceptionListener exceptionListener = conn.getExceptionListener();
                        if (exceptionListener != null) {
                            final JMSException je = new JMSException(me.toString(), failedOver ? HornetQConnection.EXCEPTION_FAILOVER : HornetQConnection.EXCEPTION_DISCONNECT);
                            je.initCause((Throwable)me);
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    exceptionListener.onException(je);
                                }
                            }).start();
                        }
                    }
                    catch (JMSException e) {
                        if (conn.closed) break block5;
                        HornetQJMSClientLogger.LOGGER.errorCallingExcListener((Exception)((Object)e));
                    }
                }
            }
        }

        public void beforeReconnect(HornetQException me) {
        }
    }
}

