# Razor Internationalization and Localization – technote

This captures the most basic information about working with the i18n and l10n
infrastructure in razor-server, for developers.  Please contribute back to
this document as you discover the shortfalls.

## Translatable Strings

We want all our user-visible strings to be able to be translated in error
messages, etc.  We do not want to translate, eg, machine keys such as "policy"
used in commands.

To facilitate this, some simple rules:

1. Wrap all strings in calls to the translation function `_`, which is
   available everywhere.

2. Only pass static strings to the `_` function.

3. Use `sprintf` style interpolation with named values to add dynamic data to
   translatable strings.

An example of this in use:

    data['name'] =~ /^[a-z]+$/i or
      raise _('the object name must be letters only; you supplied %{raw}') %
      {raw: data['name'].inspect}

See [Kernel#sprintf](http://ruby-doc.org/core-1.9.3/Kernel.html#method-i-sprintf)
for details of interpolation; named interpolations are found at the very bottom
of the documentation.  In general use "untyped" interpolation with `%{}` for
everything except floating point numbers, where `%<>f` formatting is appropriate.


## Updating the translation table

Before you commit, you should ensure that the translation table template is up
to date.  This helps translators find strings that need work:

    rxgettext -o locales/razor-server.pot --no-wrap --sort-output \
      --package-name 'Razor Server' --package-version "$(git describe)" \
      --copyright-holder="Puppet Labs, LLC" --copyright-year="2014" \
      *.rb $(find lib -name '*.rb')

That mouthful is a bit hard to remember, so it is wrapped up in a script:

    ./locales/update-pot.sh

That should work from anywhere, and will update the `locales/razor-server.pot`
file to contain any new translatable strings.  You should review that and
ensure any appropriate changes are merged with every commit you make.

Unfortunately, the template will contain some small, unhelpful changes every
time you run (eg: the last date generated), so you should be careful to only
retain valuable changes to the content.
