/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.remoting.PackedInteger;
import org.jboss.ejb.client.remoting.ProtocolMessageHandler;
import org.jboss.logging.Logger;
import org.jboss.remoting3.MessageInputStream;

class ClusterRemovalMessageHandler
extends ProtocolMessageHandler {
    private static final Logger logger = Logger.getLogger(ClusterRemovalMessageHandler.class);
    private final EJBReceiverContext ejbReceiverContext;

    ClusterRemovalMessageHandler(EJBReceiverContext ejbReceiverContext) {
        this.ejbReceiverContext = ejbReceiverContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processMessage(MessageInputStream messageInputStream) throws IOException {
        if (messageInputStream == null) {
            throw new IllegalArgumentException("Cannot read from a null stream");
        }
        HashSet<String> removedClusters = new HashSet<String>();
        try {
            DataInputStream input = new DataInputStream((InputStream)messageInputStream);
            int clusterCount = PackedInteger.readPackedInteger(input);
            for (int i = 0; i < clusterCount; ++i) {
                String clusterName = input.readUTF();
                removedClusters.add(clusterName);
            }
        }
        finally {
            messageInputStream.close();
        }
        EJBClientContext clientContext = this.ejbReceiverContext.getClientContext();
        logger.debug((Object)("Received a cluster removal message for " + removedClusters.size() + " clusters " + Arrays.toString(removedClusters.toArray())));
        for (String clusterName : removedClusters) {
            clientContext.removeCluster(clusterName);
        }
    }
}

