// Copyright 2010 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * @fileoverview Character lists and their classifications used by character
 * picker widget. Autogenerated from Unicode data:
 * https://sites/cibu/character-picker.
 *
 */

goog.provide('goog.i18n.CharPickerData');



/**
 * Object holding two level character organization and character listing.
 * @constructor
 */
goog.i18n.CharPickerData = function() {};


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SYMBOL = goog.getMsg('Symbol');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_ARROWS = goog.getMsg('Arrows');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_BRAILLE = goog.getMsg('Braille');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_CONTROL_PICTURES =
    goog.getMsg('Control Pictures');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_CURRENCY = goog.getMsg('Currency');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_EMOTICONS = goog.getMsg('Emoticons');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_GAME_PIECES = goog.getMsg('Game Pieces');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_GENDER_AND_GENEALOGICAL =
    goog.getMsg('Gender and Genealogical');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_GEOMETRIC_SHAPES =
    goog.getMsg('Geometric Shapes');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_KEYBOARD_AND_UI =
    goog.getMsg('Keyboard and UI');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_LATIN_1_SUPPLEMENT =
    goog.getMsg('Latin 1 Supplement');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_MATH = goog.getMsg('Math');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_MATH_ALPHANUMERIC =
    goog.getMsg('Math Alphanumeric');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_MISCELLANEOUS = goog.getMsg('Miscellaneous');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_MUSICAL = goog.getMsg('Musical');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_STARS_ASTERISKS =
    goog.getMsg('Stars/Asterisks');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SUBSCRIPT = goog.getMsg('Subscript');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SUPERSCRIPT = goog.getMsg('Superscript');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_TECHNICAL = goog.getMsg('Technical');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_TRANSPORT_AND_MAP =
    goog.getMsg('Transport And Map');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_WEATHER_AND_ASTROLOGICAL =
    goog.getMsg('Weather and Astrological');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_YIJING_TAI_XUAN_JING =
    goog.getMsg('Yijing / Tai Xuan Jing');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HISTORIC = goog.getMsg('Historic');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY = goog.getMsg('Compatibility');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_EMOJI = goog.getMsg('Emoji');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_PEOPLE_AND_EMOTIONS =
    goog.getMsg('People and Emotions');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_ANIMALS_PLANTS_AND_FOOD =
    goog.getMsg('Animals, Plants and Food');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_OBJECTS = goog.getMsg('Objects');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SPORTS_CELEBRATIONS_AND_ACTIVITIES =
    goog.getMsg('Sports, Celebrations and Activities');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_TRANSPORT_MAPS_AND_SIGNAGE =
    goog.getMsg('Transport, Maps and Signage');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_WEATHER_SCENES_AND_ZODIAC_SIGNS =
    goog.getMsg('Weather, Scenes and Zodiac signs');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_ENCLOSED = goog.getMsg('Enclosed');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_MARKS = goog.getMsg('Marks');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SYMBOLS = goog.getMsg('Symbols');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_PUNCTUATION = goog.getMsg('Punctuation');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_ASCII_BASED = goog.getMsg('ASCII Based');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_DASH_CONNECTOR = goog.getMsg('Dash/Connector');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_OTHER = goog.getMsg('Other');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_PAIRED = goog.getMsg('Paired');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_NUMBER = goog.getMsg('Number');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_DECIMAL = goog.getMsg('Decimal');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_ENCLOSED_DOTTED =
    goog.getMsg('Enclosed/Dotted');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_FRACTIONS_RELATED =
    goog.getMsg('Fractions/Related');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_FORMAT_WHITESPACE =
    goog.getMsg('Format & Whitespace');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_FORMAT = goog.getMsg('Format');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_VARIATION_SELECTOR =
    goog.getMsg('Variation Selector');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_WHITESPACE = goog.getMsg('Whitespace');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_MODIFIER = goog.getMsg('Modifier');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_ENCLOSING = goog.getMsg('Enclosing');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_NONSPACING = goog.getMsg('Nonspacing');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SPACING = goog.getMsg('Spacing');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_LATIN = goog.getMsg('Latin');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_COMMON = goog.getMsg('Common');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_FLIPPED_MIRRORED =
    goog.getMsg('Flipped/Mirrored');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_PHONETICS_IPA = goog.getMsg('Phonetics (IPA)');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_PHONETICS_X_IPA =
    goog.getMsg('Phonetics (X-IPA)');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_OTHER_EUROPEAN_SCRIPTS =
    goog.getMsg('Other European Scripts');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_ARMENIAN = goog.getMsg('Armenian');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_CYRILLIC = goog.getMsg('Cyrillic');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_GEORGIAN = goog.getMsg('Georgian');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_GREEK = goog.getMsg('Greek');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_CYPRIOT = goog.getMsg('Cypriot');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_GLAGOLITIC = goog.getMsg('Glagolitic');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_GOTHIC = goog.getMsg('Gothic');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_LINEAR_B = goog.getMsg('Linear B');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_OGHAM = goog.getMsg('Ogham');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_OLD_ITALIC = goog.getMsg('Old Italic');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_RUNIC = goog.getMsg('Runic');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SHAVIAN = goog.getMsg('Shavian');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_AMERICAN_SCRIPTS =
    goog.getMsg('American Scripts');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_CANADIAN_ABORIGINAL =
    goog.getMsg('Canadian Aboriginal');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_CHEROKEE = goog.getMsg('Cherokee');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_DESERET = goog.getMsg('Deseret');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_AFRICAN_SCRIPTS =
    goog.getMsg('African Scripts');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_EGYPTIAN_HIEROGLYPHS =
    goog.getMsg('Egyptian Hieroglyphs');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_ETHIOPIC = goog.getMsg('Ethiopic');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_MEROITIC_CURSIVE =
    goog.getMsg('Meroitic Cursive');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_MEROITIC_HIEROGLYPHS =
    goog.getMsg('Meroitic Hieroglyphs');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_NKO = goog.getMsg('Nko');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_TIFINAGH = goog.getMsg('Tifinagh');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_VAI = goog.getMsg('Vai');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_BAMUM = goog.getMsg('Bamum');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_COPTIC = goog.getMsg('Coptic');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_OSMANYA = goog.getMsg('Osmanya');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_MIDDLE_EASTERN_SCRIPTS =
    goog.getMsg('Middle Eastern Scripts');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_ARABIC = goog.getMsg('Arabic');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HEBREW = goog.getMsg('Hebrew');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_IMPERIAL_ARAMAIC =
    goog.getMsg('Imperial Aramaic');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_INSCRIPTIONAL_PAHLAVI =
    goog.getMsg('Inscriptional Pahlavi');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_INSCRIPTIONAL_PARTHIAN =
    goog.getMsg('Inscriptional Parthian');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_MANDAIC = goog.getMsg('Mandaic');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_OLD_SOUTH_ARABIAN =
    goog.getMsg('Old South Arabian');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SAMARITAN = goog.getMsg('Samaritan');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SYRIAC = goog.getMsg('Syriac');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_AVESTAN = goog.getMsg('Avestan');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_CARIAN = goog.getMsg('Carian');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_CUNEIFORM = goog.getMsg('Cuneiform');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_LYCIAN = goog.getMsg('Lycian');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_LYDIAN = goog.getMsg('Lydian');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_OLD_PERSIAN = goog.getMsg('Old Persian');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_PHOENICIAN = goog.getMsg('Phoenician');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_UGARITIC = goog.getMsg('Ugaritic');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SOUTH_ASIAN_SCRIPTS =
    goog.getMsg('South Asian Scripts');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_BENGALI = goog.getMsg('Bengali');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_CHAKMA = goog.getMsg('Chakma');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_DEVANAGARI = goog.getMsg('Devanagari');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_GUJARATI = goog.getMsg('Gujarati');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_GURMUKHI = goog.getMsg('Gurmukhi');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_KANNADA = goog.getMsg('Kannada');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_LEPCHA = goog.getMsg('Lepcha');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_LIMBU = goog.getMsg('Limbu');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_MALAYALAM = goog.getMsg('Malayalam');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_MEETEI_MAYEK = goog.getMsg('Meetei Mayek');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_OL_CHIKI = goog.getMsg('Ol Chiki');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_ORIYA = goog.getMsg('Oriya');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SAURASHTRA = goog.getMsg('Saurashtra');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SINHALA = goog.getMsg('Sinhala');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SORA_SOMPENG = goog.getMsg('Sora Sompeng');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_TAMIL = goog.getMsg('Tamil');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_TELUGU = goog.getMsg('Telugu');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_THAANA = goog.getMsg('Thaana');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_TIBETAN = goog.getMsg('Tibetan');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_BRAHMI = goog.getMsg('Brahmi');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_KAITHI = goog.getMsg('Kaithi');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_KHAROSHTHI = goog.getMsg('Kharoshthi');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SHARADA = goog.getMsg('Sharada');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SYLOTI_NAGRI = goog.getMsg('Syloti Nagri');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_TAKRI = goog.getMsg('Takri');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SOUTHEAST_ASIAN_SCRIPTS =
    goog.getMsg('Southeast Asian Scripts');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_BALINESE = goog.getMsg('Balinese');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_BATAK = goog.getMsg('Batak');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_CHAM = goog.getMsg('Cham');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_JAVANESE = goog.getMsg('Javanese');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_KAYAH_LI = goog.getMsg('Kayah Li');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_KHMER = goog.getMsg('Khmer');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_LAO = goog.getMsg('Lao');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_MYANMAR = goog.getMsg('Myanmar');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_NEW_TAI_LUE = goog.getMsg('New Tai Lue');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_TAI_LE = goog.getMsg('Tai Le');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_TAI_THAM = goog.getMsg('Tai Tham');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_TAI_VIET = goog.getMsg('Tai Viet');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_THAI = goog.getMsg('Thai');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_BUGINESE = goog.getMsg('Buginese');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_BUHID = goog.getMsg('Buhid');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HANUNOO = goog.getMsg('Hanunoo');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_REJANG = goog.getMsg('Rejang');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_SUNDANESE = goog.getMsg('Sundanese');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_TAGALOG = goog.getMsg('Tagalog');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_TAGBANWA = goog.getMsg('Tagbanwa');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HANGUL = goog.getMsg('Hangul');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_OTHER_EAST_ASIAN_SCRIPTS =
    goog.getMsg('Other East Asian Scripts');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_BOPOMOFO = goog.getMsg('Bopomofo');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HIRAGANA = goog.getMsg('Hiragana');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_KATAKANA = goog.getMsg('Katakana');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_LISU = goog.getMsg('Lisu');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_MIAO = goog.getMsg('Miao');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_MONGOLIAN = goog.getMsg('Mongolian');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_OLD_TURKIC = goog.getMsg('Old Turkic');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_PHAGS_PA = goog.getMsg('Phags Pa');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_YI = goog.getMsg('Yi');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HAN_1_STROKE_RADICALS =
    goog.getMsg('Han 1-Stroke Radicals');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_LESS_COMMON = goog.getMsg('Less Common');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HAN_2_STROKE_RADICALS =
    goog.getMsg('Han 2-Stroke Radicals');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HAN_3_STROKE_RADICALS =
    goog.getMsg('Han 3-Stroke Radicals');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HAN_4_STROKE_RADICALS =
    goog.getMsg('Han 4-Stroke Radicals');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HAN_5_STROKE_RADICALS =
    goog.getMsg('Han 5-Stroke Radicals');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HAN_6_STROKE_RADICALS =
    goog.getMsg('Han 6-Stroke Radicals');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HAN_7_STROKE_RADICALS =
    goog.getMsg('Han 7-Stroke Radicals');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HAN_8_STROKE_RADICALS =
    goog.getMsg('Han 8-Stroke Radicals');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HAN_9_STROKE_RADICALS =
    goog.getMsg('Han 9-Stroke Radicals');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HAN_10_STROKE_RADICALS =
    goog.getMsg('Han 10-Stroke Radicals');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HAN_11_17_STROKE_RADICALS =
    goog.getMsg('Han 11..17-Stroke Radicals');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_HAN_OTHER = goog.getMsg('Han - Other');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_CJK_STROKES = goog.getMsg('CJK Strokes');


/**
 * @desc Name for a symbol or character category. Used in a pull-down list
 *   shown to a  document editing user trying to insert a special character.
 *   Newlines are not allowed; translation should be a noun and as consise as
 *   possible. More details:
 *   docs/fileview?id=0B8NbxddKsFtwYjExMGJjNzgtYjkzOS00NjdiLTlmOGQtOGVhZDkyZDU5YjM4.
 * @type {string}
 */
goog.i18n.CharPickerData.MSG_CP_IDEOGRAPHIC_DESCRIPTION =
    goog.getMsg('Ideographic Description');


/**
 * Top catagory names of character organization.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.prototype.categories = [
  goog.i18n.CharPickerData.MSG_CP_SYMBOL,
  goog.i18n.CharPickerData.MSG_CP_EMOJI,
  goog.i18n.CharPickerData.MSG_CP_PUNCTUATION,
  goog.i18n.CharPickerData.MSG_CP_NUMBER,
  goog.i18n.CharPickerData.MSG_CP_FORMAT_WHITESPACE,
  goog.i18n.CharPickerData.MSG_CP_MODIFIER,
  goog.i18n.CharPickerData.MSG_CP_LATIN,
  goog.i18n.CharPickerData.MSG_CP_OTHER_EUROPEAN_SCRIPTS,
  goog.i18n.CharPickerData.MSG_CP_AMERICAN_SCRIPTS,
  goog.i18n.CharPickerData.MSG_CP_AFRICAN_SCRIPTS,
  goog.i18n.CharPickerData.MSG_CP_MIDDLE_EASTERN_SCRIPTS,
  goog.i18n.CharPickerData.MSG_CP_SOUTH_ASIAN_SCRIPTS,
  goog.i18n.CharPickerData.MSG_CP_SOUTHEAST_ASIAN_SCRIPTS,
  goog.i18n.CharPickerData.MSG_CP_HANGUL,
  goog.i18n.CharPickerData.MSG_CP_OTHER_EAST_ASIAN_SCRIPTS,
  goog.i18n.CharPickerData.MSG_CP_HAN_1_STROKE_RADICALS,
  goog.i18n.CharPickerData.MSG_CP_HAN_2_STROKE_RADICALS,
  goog.i18n.CharPickerData.MSG_CP_HAN_3_STROKE_RADICALS,
  goog.i18n.CharPickerData.MSG_CP_HAN_4_STROKE_RADICALS,
  goog.i18n.CharPickerData.MSG_CP_HAN_5_STROKE_RADICALS,
  goog.i18n.CharPickerData.MSG_CP_HAN_6_STROKE_RADICALS,
  goog.i18n.CharPickerData.MSG_CP_HAN_7_STROKE_RADICALS,
  goog.i18n.CharPickerData.MSG_CP_HAN_8_STROKE_RADICALS,
  goog.i18n.CharPickerData.MSG_CP_HAN_9_STROKE_RADICALS,
  goog.i18n.CharPickerData.MSG_CP_HAN_10_STROKE_RADICALS,
  goog.i18n.CharPickerData.MSG_CP_HAN_11_17_STROKE_RADICALS,
  goog.i18n.CharPickerData.MSG_CP_HAN_OTHER
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_SYMBOL = [
  goog.i18n.CharPickerData.MSG_CP_ARROWS,
  goog.i18n.CharPickerData.MSG_CP_BRAILLE,
  goog.i18n.CharPickerData.MSG_CP_CONTROL_PICTURES,
  goog.i18n.CharPickerData.MSG_CP_CURRENCY,
  goog.i18n.CharPickerData.MSG_CP_EMOTICONS,
  goog.i18n.CharPickerData.MSG_CP_GAME_PIECES,
  goog.i18n.CharPickerData.MSG_CP_GENDER_AND_GENEALOGICAL,
  goog.i18n.CharPickerData.MSG_CP_GEOMETRIC_SHAPES,
  goog.i18n.CharPickerData.MSG_CP_KEYBOARD_AND_UI,
  goog.i18n.CharPickerData.MSG_CP_LATIN_1_SUPPLEMENT,
  goog.i18n.CharPickerData.MSG_CP_MATH,
  goog.i18n.CharPickerData.MSG_CP_MATH_ALPHANUMERIC,
  goog.i18n.CharPickerData.MSG_CP_MISCELLANEOUS,
  goog.i18n.CharPickerData.MSG_CP_MUSICAL,
  goog.i18n.CharPickerData.MSG_CP_STARS_ASTERISKS,
  goog.i18n.CharPickerData.MSG_CP_SUBSCRIPT,
  goog.i18n.CharPickerData.MSG_CP_SUPERSCRIPT,
  goog.i18n.CharPickerData.MSG_CP_TECHNICAL,
  goog.i18n.CharPickerData.MSG_CP_TRANSPORT_AND_MAP,
  goog.i18n.CharPickerData.MSG_CP_WEATHER_AND_ASTROLOGICAL,
  goog.i18n.CharPickerData.MSG_CP_YIJING_TAI_XUAN_JING,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_SYMBOL = [
  '2>807AnTMm6e6HDk%`O728F1f4V1PNF2WF1G}58?]514M]Ol1%2l2^3X1U:1Un2Mb>$0MD-(068k11I3706:%MwiZ06',
  ';oA0FN',
  '(j90d3',
  'H3XBMQQ10HB(2106uPM]N:qol202S20V2I:Z0^xM0:91E]J6O6',
  ';(i1-5W?',
  'Q6A06f5#1H2,]4MeEY[W1@3W}891N1GF1GN18N1P%k',
  '2JA0sOc',
  'oG90nMcPTFNfFEQE10t2H3kQ7X1sj>$0OW6*F%E',
  '(P90UGv771.Uv46%7Y^Y1F2mc]1M+<Z1',
  '9FP1',
  ':3f1En5894WX3:2v+]lEQ?60f2E11OH1P1M]1U11UfCf111MuUmH6Ue6WGGu:26G8:2NO$M:16H8%2V28H211cvg.]4s9AnU#5PNdkX4-1Gc24P1P2:2P2:2P2:2P2:2P2g>50M8V2868G8,8M88mW888E868G8888868GM8k8M8M88,8d1eE8U8d1%46bf$0:;c8%Ef1Ev2:28]BmMbp)02p8071WO6WUw+w0',
  '9G6e:-EGX26G6(k70Ocm,]AWG,8OUmOO68E86uMeU^`Q1t78V686GG6GM8|88k8-58MGs8k8d28M8U8Ok8-UGF28F28#28F28#28F28#28F28#28F28sGd4rLS1H1',
  '1FGW8Y040Mg%50EHB686WU8l1$Uv4?8En1E8|:29168U8718k8kG8M868688686e686888,148MO8|8E]7wV10k2tN1cYf806813692W]3%68X2f2|O6G86%1P5m6%5$6%468e[E8c11126v1MH2|%F9DuM8E86m8UTN%06',
  ';DA0k2mO1NM[d3GV5eEms$6ut2WN493@5OA;80sD790UOc$sGk%2MfDE',
  ';OA0v5-3g510E^jW1WV1:l',
  'Qq80N1871QC30',
  'XFu6e6^X80O?vE82+Y16T+g1Ug2709+H12F30QjW0PC6',
  'gM90sW#1G6$l7H1!%2N2O?ml1]6?',
  'g?i1N6',
  'Q4A0F1mv3}1v8,uUe^zX171',
  'w8A0sf7c2WA0#5A>E1-7',
  'I{)0%4!P7|%4}3A,$0dA',
  '(PD0M(ZU16H1-3e!u6'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_EMOJI = [
  goog.i18n.CharPickerData.MSG_CP_PEOPLE_AND_EMOTIONS,
  goog.i18n.CharPickerData.MSG_CP_ANIMALS_PLANTS_AND_FOOD,
  goog.i18n.CharPickerData.MSG_CP_OBJECTS,
  goog.i18n.CharPickerData.MSG_CP_SPORTS_CELEBRATIONS_AND_ACTIVITIES,
  goog.i18n.CharPickerData.MSG_CP_TRANSPORT_MAPS_AND_SIGNAGE,
  goog.i18n.CharPickerData.MSG_CP_WEATHER_SCENES_AND_ZODIAC_SIGNS,
  goog.i18n.CharPickerData.MSG_CP_ENCLOSED,
  goog.i18n.CharPickerData.MSG_CP_MARKS,
  goog.i18n.CharPickerData.MSG_CP_SYMBOLS
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_EMOJI = [
  '^6A0n2:IE]7Y>X18N1%1-28EOO8871G|%U-5W?',
  'I6A0A_X1c8N6eXBt5',
  ';O906PJG]m1C1Amew)X16:It1]2W68E8X168[8d68MP171P1!1372',
  '2DA0s%76o]W1@3nAN1GF1GN18N1Xzd191N38U9I',
  '(DA0v1O]2694t1m72$2>X1d1%DvXUvBN6',
  'Q4A0F1mv4|HAUe98(rX1@2]k',
  'Y#90;v308ICU1d2W-3H9EH1-3e!u6',
  ';5A09M9188:48WE8n5EH2',
  'Y%C0(wV1P7N3[EP1M'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_PUNCTUATION = [
  goog.i18n.CharPickerData.MSG_CP_ASCII_BASED,
  goog.i18n.CharPickerData.MSG_CP_DASH_CONNECTOR,
  goog.i18n.CharPickerData.MSG_CP_OTHER,
  goog.i18n.CharPickerData.MSG_CP_PAIRED,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_PUNCTUATION = [
  ':2M8EG886[6O6f2H6eP16u',
  '14f4gX80c%36%1gu30:26Q3t0XG',
  '(s70:<.MOEmEGGG8OEms88Iu3068G6n1!',
  'n36f48v2894X1;P80sP26[6]46P16nvMPF6f3c1^F1H76:2,va@1%5M]26;7106G,fh,Gs2Ms06nPcXF6f48v288686',
  'gm808kQT30MnN72v1U8U(%t0Eb(t0',
  'Ig80e91E91686W8$EH1X36P162pw0,12-1G|8F18W86nDE8c8M[6O6X2E8f2886'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_NUMBER = [
  goog.i18n.CharPickerData.MSG_CP_DECIMAL,
  goog.i18n.CharPickerData.MSG_CP_ENCLOSED_DOTTED,
  goog.i18n.CharPickerData.MSG_CP_FRACTIONS_RELATED,
  goog.i18n.CharPickerData.MSG_CP_OTHER,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_NUMBER = [
  'P4,]A6egh10,HC,1I,fb,%A,%A,%A,%A,%A,%A,%A,%A,XK,%A,X6,PP,X6,Q]10,f3,PR,vB,9F,m,nG,]K,m,A710Ocm,^SZ0,vz,f3,1I,%A,]a,AnQ0,vB,f5,9D,2Q10,5O60,',
  'gs90#7%4@1Pvt2g+20,%2s8N1]2,n3N1',
  '9G6eGEoX80Ocm,1IV1%3',
  'ot20cHYc]AE9Ck]Lcvd,^910#1oF10,vh2}1073GMQ:30P2!P1EHVMI2V0,9Ts8^aP0sHn6%JsH2s](#2fg#1wnp0l1;-70?',
  'o560EgM10,Yk10EGMo230w6u0}39175n1:aMv2$HCUXI,^E10cnQso,60@8',
  'w.80-2o?30EHVMoSU1?b}#0,'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_FORMAT_WHITESPACE = [
  goog.i18n.CharPickerData.MSG_CP_FORMAT,
  goog.i18n.CharPickerData.MSG_CP_VARIATION_SELECTOR,
  goog.i18n.CharPickerData.MSG_CP_WHITESPACE,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_FORMAT_WHITESPACE = [
  'vF;Z10U92fHf4gh40;920UX2Uf4U8M2n#0;`o0sbwt0vME',
  ']=oY506%7E^$zA#LDF1AV1',
  'fEIH602920,H3P4wB40;#s0',
  'w-10f4^#206IV10(970ols0',
  'fEAQ80?P3P4wB40^@s0'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_MODIFIER = [
  goog.i18n.CharPickerData.MSG_CP_ENCLOSING,
  goog.i18n.CharPickerData.MSG_CP_NONSPACING,
  goog.i18n.CharPickerData.MSG_CP_SPACING,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_MODIFIER = [
  '(y80M8E',
  '%+#5GG,8t1(#60E8718kWm:I,H46v%71WO|oWQ1En1sGk%2MT_t0k',
  'f!!.M%3M91gz30(C30f1695E8?8l18d2X4N32D40XH',
  '%?71HP62x60M[F2926^Py0',
  'n<686'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_LATIN = [
  goog.i18n.CharPickerData.MSG_CP_COMMON,
  goog.i18n.CharPickerData.MSG_CP_ENCLOSED,
  goog.i18n.CharPickerData.MSG_CP_FLIPPED_MIRRORED,
  goog.i18n.CharPickerData.MSG_CP_OTHER,
  goog.i18n.CharPickerData.MSG_CP_PHONETICS_IPA,
  goog.i18n.CharPickerData.MSG_CP_PHONETICS_X_IPA,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_LATIN = [
  ':5N2mN2P6}18#28V1Gl1GcG|W68cGs8|GMGMG6G}1GWG6OU8GEOG6H168E11M.s$$6f16%2Mv3P168688uW.128$IN706126H26W6:16m6$6P16Gc916[878QAa06zph0696U8EOP3o2706',
  '^x90}6^yX1#28F5m-3:6N2',
  'X4X1m6OEWku8WGc88M8H6%1nFmu11916X16H3H1%4P3[8EOmeWW.euWM918HMH6%512]I1Q^+20f+.%2X8]cfBg*10I710P1681H]E^BZ01BE',
  ']N6v16m6P16Gv26W6W6G6H286O6G6m86OE86GUGGEGOEv2s8sG!OEOt2mV38?A570@3%5718}2H9|G@1G72GMG#1GcGsGF1G6m|GcHuO11G6e6O88mOuX18Eo]20}1u62cW0F1v6N1e68M91?H7zSi081s868EG?8E8EGcu8E8UGEw^60t5H193N3v!H1f171QmZ072f9E]96',
  '%8N2%96$uH4H3u:9M%CF28718M868UO?86G68E8868GHOeP1I>70EO6LF80E8GW11OO6918Of26868886OV3WU%2W',
  '1uH1WGeE11G6GO8G868s',
  'HZ6uP268691s15P36Al7068H8cHw!Y?20UwdW0#58s:BUbvh0d1g{A06AZW0sH2697',
  'XFX1:A6116v5H6!P3E(o706vtM8E8?86GUGE8O8M8E86W8.U12-2Qd40HBMvE,et8:2Qtq0kg710N2mN2bV)0mWOXnc'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_OTHER_EUROPEAN_SCRIPTS = [
  goog.i18n.CharPickerData.MSG_CP_ARMENIAN,
  goog.i18n.CharPickerData.MSG_CP_CYRILLIC,
  goog.i18n.CharPickerData.MSG_CP_GEORGIAN,
  goog.i18n.CharPickerData.MSG_CP_GREEK,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_CYPRIOT,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_CYRILLIC,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_GEORGIAN,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_GLAGOLITIC,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_GOTHIC,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_GREEK,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_LINEAR_B,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_OGHAM,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_OLD_ITALIC,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_RUNIC,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_SHAVIAN,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_ARMENIAN,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_GREEK
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_OTHER_EUROPEAN_SCRIPTS = [
  '(W10V3Oc8V3G6W=4',
  '2510-BuNEKuvfE',
  '(e10o{20eG@2mMGEJ',
  ']]8E88#18@3P3$wC70@1GcGV3GcGs8888l1888888O#48U8eE8E88OEOUeE8k8eE8E88{l706W',
  '^-+0cG8@386OG',
  '2{h0F4W[872{<g06g^A0-2;;V0M8,8:2',
  ';Y40V3]3cW2a70V38e',
  '^tB0F48F4',
  '^l*0V2',
  ']@MG6OEX7EO71f18GU8E;{(0#6YBt0@5OJE',
  '(z)0|8N28t1868N1GF1937B',
  'o_50l2',
  'oh*0#28M',
  'g|50N7',
  'A;*0N4',
  'oe10g^$0U',
  'XG%$$%6Ef26OoN70888888n5G[8uuuuH189Rr:706we708E11EH1EH1EH16'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_AMERICAN_SCRIPTS = [
  goog.i18n.CharPickerData.MSG_CP_CANADIAN_ABORIGINAL,
  goog.i18n.CharPickerData.MSG_CP_CHEROKEE,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_DESERET
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_AMERICAN_SCRIPTS = [
  'YP507w]oN6',
  'wG50t7',
  ';(*0F7'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_AFRICAN_SCRIPTS = [
  goog.i18n.CharPickerData.MSG_CP_EGYPTIAN_HIEROGLYPHS,
  goog.i18n.CharPickerData.MSG_CP_ETHIOPIC,
  goog.i18n.CharPickerData.MSG_CP_MEROITIC_CURSIVE,
  goog.i18n.CharPickerData.MSG_CP_MEROITIC_HIEROGLYPHS,
  goog.i18n.CharPickerData.MSG_CP_NKO,
  goog.i18n.CharPickerData.MSG_CP_TIFINAGH,
  goog.i18n.CharPickerData.MSG_CP_VAI,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_BAMUM,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_COPTIC,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_NKO,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_OSMANYA
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_AFRICAN_SCRIPTS = [
  ';Y[0}}N9',
  ';(40l68MGk88MGt38MG@28MGk88MGN18758MG}5el2ON2(;60}1.k8k8k8k8k8k8k8kI8X0cGcGc.k8kDDe0E',
  '(L,072m6',
  ';I,0-2',
  'Q420l3P1MK1?W',
  'o_B0}4$3X1',
  '^th0NO8#2*2',
  '(5i0F7GcY4p0tpzup06',
  'Q210F12$A0}9O6eka1E',
  '^720E',
  'g?*0t2G,'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_MIDDLE_EASTERN_SCRIPTS = [
  goog.i18n.CharPickerData.MSG_CP_ARABIC,
  goog.i18n.CharPickerData.MSG_CP_HEBREW,
  goog.i18n.CharPickerData.MSG_CP_IMPERIAL_ARAMAIC,
  goog.i18n.CharPickerData.MSG_CP_INSCRIPTIONAL_PAHLAVI,
  goog.i18n.CharPickerData.MSG_CP_INSCRIPTIONAL_PARTHIAN,
  goog.i18n.CharPickerData.MSG_CP_MANDAIC,
  goog.i18n.CharPickerData.MSG_CP_OLD_SOUTH_ARABIAN,
  goog.i18n.CharPickerData.MSG_CP_SAMARITAN,
  goog.i18n.CharPickerData.MSG_CP_SYRIAC,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_ARABIC,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_AVESTAN,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_CARIAN,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_CUNEIFORM,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_HEBREW,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_LYCIAN,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_LYDIAN,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_OLD_PERSIAN,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_PHOENICIAN,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_SYRIAC,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_UGARITIC,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_ARABIC,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_HEBREW
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_MIDDLE_EASTERN_SCRIPTS = [
  'op10U8,11Gl2m,]1F1O68W-18V6H2l1P774XQ8?^F60g2#0#2YVx06r##0vAry%0U]3[-1f11vV2QG$0V1',
  'oj108G91V2eUC6F1886A?$0',
  '(>+0@18!',
  'g!,0t1es',
  'ox,0@1Gs',
  '^F20F2eZE',
  'Id,0-2',
  'AA20@1X2N1Qt60{w6072',
  'wq10P1O]2[?X2',
  '^u10UH46%2H7[fD6=Wc1HkG,8M',
  '(r,0-4Ok',
  ';Y*0V4',
  'gE=0-@HD@8H1M',
  'Qk10^>$0!f35}$0#2:168',
  '^V*0l2',
  'AA,0N2e',
  'Aw*0F3WF1',
  'I7,0d2O',
  ';;10F1868t2v2Eq5%2V2',
  'It*0t28',
  'I!10MA^e1M8V2868G8,8M88mW888E868G8888868GM8k8M8M88,8d1eE8U8d1{W$0-813@Wv1#5G-4v371fAE88FC',
  '2a(08.F18U886868!'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_SOUTH_ASIAN_SCRIPTS = [
  goog.i18n.CharPickerData.MSG_CP_BENGALI,
  goog.i18n.CharPickerData.MSG_CP_CHAKMA,
  goog.i18n.CharPickerData.MSG_CP_DEVANAGARI,
  goog.i18n.CharPickerData.MSG_CP_GUJARATI,
  goog.i18n.CharPickerData.MSG_CP_GURMUKHI,
  goog.i18n.CharPickerData.MSG_CP_KANNADA,
  goog.i18n.CharPickerData.MSG_CP_LEPCHA,
  goog.i18n.CharPickerData.MSG_CP_LIMBU,
  goog.i18n.CharPickerData.MSG_CP_MALAYALAM,
  goog.i18n.CharPickerData.MSG_CP_MEETEI_MAYEK,
  goog.i18n.CharPickerData.MSG_CP_OL_CHIKI,
  goog.i18n.CharPickerData.MSG_CP_ORIYA,
  goog.i18n.CharPickerData.MSG_CP_SAURASHTRA,
  goog.i18n.CharPickerData.MSG_CP_SINHALA,
  goog.i18n.CharPickerData.MSG_CP_SORA_SOMPENG,
  goog.i18n.CharPickerData.MSG_CP_TAMIL,
  goog.i18n.CharPickerData.MSG_CP_TELUGU,
  goog.i18n.CharPickerData.MSG_CP_THAANA,
  goog.i18n.CharPickerData.MSG_CP_TIBETAN,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_BRAHMI,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_KAITHI,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_KANNADA,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_KHAROSHTHI,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_SHARADA,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_SYLOTI_NAGRI,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_TAKRI,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_BENGALI,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_DEVANAGARI,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_GURMUKHI,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_ORIYA,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_TIBETAN
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_SOUTH_ASIAN_SCRIPTS = [
  'gg206:2sG6G@18k8OMOf1n16W@1:*64[E958kG6GE.[6',
  'wH.0F3X1F146EP3F1',
  '(X20-4Ov1X16G718c8k9[6gMf0,DRg0M]4E8l18k[6H1YEg0l1',
  '(*20!8E8@18k868UOv1X16W|fk6*uE958s8E8E:16',
  'gg206fEcW6G@18k8GG693.,GE:v6a*E958UW6GEO%26O',
  'QR30s8E8}18,8UO936W,86CA6958k8E8Mu6116',
  'oZ70F392N1OE=3#1',
  '(r60l2H3O|K4|W|',
  '^c30s8E8t3Gf1n16WV1Okw@4053506P5k8E8M.[6',
  'wGj0?eEvI73$W,iOUOMfLs86',
  ';g70l3m6pc',
  'gg206%bsG6G@18k868UO13EWl1PY6CjE958kG6GE$6[6',
  'oni0d4X2|486n4d1',
  'oo30l1O728!8Gk94A+40j@406X6Wc88sv16',
  '2D.0F2u,',
  ';3308cOE8MO6886O6OEO|12]1-1=AX5UOE8M.',
  'wF30s8E8}18,8UOX26m6W,$sPA6=LEP5k8E8Mu6116',
  'wq10P1O:5,PPV311_?',
  '2{30|8?GV2888MGE8M8M8M8M8M8|8EH2GUf4s8c8kW6Ii806e,GsL$806f288W6f468ek8E86ec8M8M8M8M8M8|8E.',
  'YG40M2e30M8MO6',
  'Y^-0#4X1kWt24AE:4N1',
  '26.0}311k=5E94?',
  'YZ30',
  'gU,0X1M8E8V291s$!=7E86eMv3EW',
  'QT.0N4P1su,48EX4F1',
  '(bi068E8M8}1eMy3OW92U',
  'Yv:0-3]1,y271',
  'Yr2068',
  'Yf20s',
  'Qz20G93EG',
  'Q0306',
  'A|30]4.WWW91we#0M5e#0868$n1.WWW91'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_SOUTHEAST_ASIAN_SCRIPTS = [
  goog.i18n.CharPickerData.MSG_CP_BALINESE,
  goog.i18n.CharPickerData.MSG_CP_BATAK,
  goog.i18n.CharPickerData.MSG_CP_CHAM,
  goog.i18n.CharPickerData.MSG_CP_JAVANESE,
  goog.i18n.CharPickerData.MSG_CP_KAYAH_LI,
  goog.i18n.CharPickerData.MSG_CP_KHMER,
  goog.i18n.CharPickerData.MSG_CP_LAO,
  goog.i18n.CharPickerData.MSG_CP_MYANMAR,
  goog.i18n.CharPickerData.MSG_CP_NEW_TAI_LUE,
  goog.i18n.CharPickerData.MSG_CP_TAI_LE,
  goog.i18n.CharPickerData.MSG_CP_TAI_THAM,
  goog.i18n.CharPickerData.MSG_CP_TAI_VIET,
  goog.i18n.CharPickerData.MSG_CP_THAI,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_BUGINESE,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_BUHID,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_HANUNOO,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_KHMER,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_REJANG,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_SUNDANESE,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_TAGALOG,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_TAGBANWA
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_SOUTHEAST_ASIAN_SCRIPTS = [
  '(C70F4n1kWV2.!KBUP4d1f3!',
  '(T70V312MK2F1',
  'Q`i0t392E8sW,GM=4F191$6',
  '2:i0F4P171G,W6q8MP4F1P1',
  '2zi0V3$6)s',
  ';I6073GE8?]2E8UO,m,Hi-2Srl286O',
  'g:3068G68GmM8k8E88G68M86.GU11,GMC4Gc86.8c',
  'QK40-3:1}1WMOO6uEW71918,W6Iwe0V18,D-e0#192MWE8EGkOMH1|8[M;xe0[',
  'Y%60@3]1k$?O6K4d1u6',
  '2z60t2GU',
  '^@60#4]3,m,mk8c`7,8l2Gn3',
  '^7j0N48O6GUG8H2686K48EG6e68f2',
  ';z30N48691c.71*3Gk11!',
  '2>60}1u6xU',
  '2C606.#1',
  'AA60l1O6RE',
  'gM60v311',
  'Y%i0}1H2C271',
  'IO70t2H1l1PNsyTE%271',
  'I760718MH36K3E',
  '2C606%3718E86'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HANGUL = [
  goog.i18n.CharPickerData.MSG_CP_OTHER,
  '\u1100',
  '\u1102',
  '\u1103',
  '\u1105',
  '\u1106',
  '\u1107',
  '\u1109',
  '\u110B',
  '\u110C',
  '\u110E',
  '\u110F',
  '\u1110',
  '\u1111',
  '\u1112',
  '\u1159',
  goog.i18n.CharPickerData.MSG_CP_HISTORIC,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_HANGUL = [
  'AzC0M88,8F1X1mWMPqYyh0}1WV42BA06Tis06',
  ';gj0}}-I',
  '(zk0Vr',
  '(+i0MAj20}}-I',
  'A,i0?2#30Vr',
  'A-i0EIS40Vr',
  'Y-i0EY]40}}-I',
  'w-i0IC60}}-I',
  '(-i06^U70Vr',
  '^-i0Q`70}}-I',
  'I}r0Vr',
  'wqs0Vr',
  '2.i02YA0Vr',
  'A.i0Y}A0Vr',
  'I.i0(qB0Vr',
  'Q.i0',
  'oh40FN^L80d8',
  'oJD0#2]5#2IGs0MX5#2OcGcGcGE'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_OTHER_EAST_ASIAN_SCRIPTS = [
  goog.i18n.CharPickerData.MSG_CP_BOPOMOFO,
  goog.i18n.CharPickerData.MSG_CP_HIRAGANA,
  goog.i18n.CharPickerData.MSG_CP_KATAKANA,
  goog.i18n.CharPickerData.MSG_CP_LISU,
  goog.i18n.CharPickerData.MSG_CP_MIAO,
  goog.i18n.CharPickerData.MSG_CP_MONGOLIAN,
  goog.i18n.CharPickerData.MSG_CP_OLD_TURKIC,
  goog.i18n.CharPickerData.MSG_CP_PHAGS_PA,
  goog.i18n.CharPickerData.MSG_CP_YI,
  goog.i18n.CharPickerData.MSG_CP_HISTORIC + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_PHAGS_PA,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_BOPOMOFO,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_HIRAGANA,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_KATAKANA,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_PHAGS_PA,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY + ' - ' +
      goog.i18n.CharPickerData.MSG_CP_YI
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_OTHER_EAST_ASIAN_SCRIPTS = [
  'AzC0M88,8F1X1mWM]Ht3XAV2I8s06+f(06^`B0M',
  'AzC0M88F2X1mWM8#7.H8fD6QCD1T0l065is0U196G6f8wqs0946',
  'AzC0M88F2X1mWM%8N8fD6n8V1I2D1L0l065is0U196:8Egqs0946',
  'oph0l3m6pc',
  '2591F611F4f1d1',
  'gU60?O8,m738t4$t38aEE:4H9',
  '2>,0l6',
  'wU6068AU606e,Gs',
  'AzC06e,Gs2qT0-18}}-FO@4DL10',
  'ohi0}4',
  'Ql)0M',
  '^%C0f91MF1^oU1bE$0Ujys06',
  '^%C0HIPDF1vRF48@7g`r0N18}3r%s06',
  'Ql)0M',
  'Ql)0M'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_1_STROKE_RADICALS = [
  '\u4E00',
  '\u4E28',
  '\u4E36',
  '\u4E3F',
  '\u4E59',
  '\u4E85',
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY,
  goog.i18n.CharPickerData.MSG_CP_LESS_COMMON
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_HAN_1_STROKE_RADICALS = [
  'ItK0l3]1f7YL10',
  ';wK0M8!',
  'AyK0k8[',
  '^yK0,8N1^w30',
  'Q#K0sG}2YfL0',
  'Q)K0k',
  '(bC0c]R]q8O8f2EgqB2E5Cl1]116$f7fG',
  'A(D0t3(rX1V288k8!8k8868|8l188U8718M8N48E88GE8#48MG@3oA20]G2P60;QB0]9^(20^7L0t2'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_2_STROKE_RADICALS = [
  '\u4E8C',
  '\u4EA0',
  '\u4EBA',
  '\u513F',
  '\u5165',
  '\u516B',
  '\u5182',
  '\u5196',
  '\u51AB',
  '\u51E0',
  '\u51F5',
  '\u5200',
  '\u529B',
  '\u52F9',
  '\u5315',
  '\u531A',
  '\u5338',
  '\u5341',
  '\u535C',
  '\u5369',
  '\u5382',
  '\u53B6',
  '\u53C8',
  '\u8BA0',
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY,
  goog.i18n.CharPickerData.MSG_CP_LESS_COMMON
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_HAN_2_STROKE_RADICALS = [
  '^)K0M8N1',
  '(+K0N2',
  'A.K0lww)K0',
  '(gL0V3',
  'IkL0cI870',
  '(kL0}1QyK0',
  ';mL0#1Yw50',
  'woL0-1',
  'oqL0#4',
  'YvL0-1',
  'QxL0?',
  'QyL0}D',
  'Y;L0V58@2',
  '^^L0d2',
  'g{L0U',
  '^{L0t2^IK0',
  'w0M0!',
  'g1M0E8}1QHK0',
  '^3M071',
  'A5M0F2',
  'Y7M0t4;XD0',
  'ACM0l1',
  '(DM0V2IS10',
  'Y]a0tD',
  'QcC0}1%P8]qG688P1W6G6mO8^pB2F28d292%B6f6%A15P1ODrl1f1E9386H18e11Ee[n16[91e11.G$H1n18611$X2cX5k',
  ';+D0tN8l49H2i40kAsS1uH3v1H788]9@18}2872Gk8E8|8s88E8G-18778@28lF8-6G,8@48#486GF28d28t18t48N3874868-78F58V18}28F48l48lG868d18N18#18!8FN8@98FP8s8}F8N28,8VG8F18tF8}2(s30%U;@101bI-50QE60^{40;X60IhB0}Oo_20d3j%S1'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_3_STROKE_RADICALS = [
  '\u53E3',
  '\u56D7',
  '\u571F',
  '\u58EB',
  '\u5902',
  '\u590A',
  '\u5915',
  '\u5927',
  '\u5973',
  '\u5B50',
  '\u5B80',
  '\u5BF8',
  '\u5C0F',
  '\u5C22',
  '\u5C38',
  '\u5C6E',
  '\u5C71',
  '\u5DDB',
  '\u5DE5',
  '\u5DF1',
  '\u5DFE',
  '\u5E72',
  '\u5E7A',
  '\u5E7F',
  '\u5EF4',
  '\u5EFE',
  '\u5F0B',
  '\u5F13',
  '\u5F50',
  '\u5F61',
  '\u5F73',
  '\u7E9F',
  '\u95E8',
  '\u98DE',
  '\u9963',
  '\u9A6C',
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY,
  goog.i18n.CharPickerData.MSG_CP_LESS_COMMON
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_HAN_3_STROKE_RADICALS = [
  'IGM0dY8FM8tB',
  '^`M0d6^GJ0',
  'g3N0tZ8}48!Q#I0Ge',
  'gCN0%W}1',
  'YlN0k',
  '2mN0|',
  'AnN0l1',
  '(oN0-6',
  'wvN07D8}T',
  '2DO0N4',
  'YHO0-Aw]50',
  'QSO0}1',
  'YUO0t1^=H0',
  'AWO0@1',
  'AYO08t4',
  '2dO0E',
  'A$K0A#30-W',
  'I.O0c8E',
  'A:O0|',
  'I;O071',
  'Y<O0V78@2',
  '^{O0s',
  '2$K0oM40U',
  'A}O0lAw7H0',
  '(9P0,',
  'wAP071',
  ';BP0s',
  'oCP0d5',
  'AIP0d1',
  'wJP0!8s',
  'QLP0F7^]G06',
  '(gX0tD',
  'wud0t4',
  'obe0',
  'wne0l4',
  '(:e0V5',
  'YeC0#2P=11Wm11686W(uB2}18l58E8EGMP8:5]6]9Lvl1G86:1mP26m6%1me%1E11X1OmEf1692Ge6H1%1Gm8GX3kX4[F1',
  'YAE0@G8V(I!20|I!10E:5fX18EwYR1%1u8Gn3v11B1693P2uO91$8OH2H713vMXG%1%K:6]SG13%2H@vX93tU8F587w8}V8-68tA8dO8db8V38758V28t58F18k8#C8t!8V78V98tU8lT8de8}}V98lB8}B8#387987H8#38NJ8@78U8N18U8kgE10(L10v_X4ngA6109Nn2v2Ac101O1}HSQ*1094^.50N2:BP6Ay10Q<40]5;s20AE20V1H9^j20l1%g-3YY20YU10}zAv10@2;310F1]E72X3}1DeT18'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_4_STROKE_RADICALS = [
  '\u5FC3',
  '\u6208',
  '\u6236',
  '\u624B',
  '\u652F',
  '\u6534',
  '\u6587',
  '\u6597',
  '\u65A4',
  '\u65B9',
  '\u65E0',
  '\u65E5',
  '\u66F0',
  '\u6708',
  '\u6728',
  '\u6B20',
  '\u6B62',
  '\u6B79',
  '\u6BB3',
  '\u6BCB',
  '\u6BD4',
  '\u6BDB',
  '\u6C0F',
  '\u6C14',
  '\u6C34',
  '\u706B',
  '\u722A',
  '\u7236',
  '\u723B',
  '\u723F',
  '\u7247',
  '\u7259',
  '\u725B',
  '\u72AC',
  '\u89C1',
  '\u8D1D',
  '\u8F66',
  '\u97E6',
  '\u98CE',
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY,
  goog.i18n.CharPickerData.MSG_CP_LESS_COMMON
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_HAN_4_STROKE_RADICALS = [
  'oSP0#q',
  'Y]P074',
  'o{P0-1',
  'g}P0F)2gF0',
  '((Q0U',
  '(oM0YG40d7(cA0',
  '(;Q0V1YNF0',
  'I=Q071',
  'Y>Q0-1',
  'Q@Q0d3',
  ';^Q0U',
  ';@L0Y350FOH1os602W80',
  ';@L0wR5071868k',
  '(LR0-2Y070',
  'wOR0}}N4:+IBD0',
  '2TS0@5',
  '2ZS0}1I-D0',
  'AbS0F5',
  'YgS072',
  'oiS0!',
  'YjS0k',
  '2kS0t4',
  '(oS0U',
  'IpS0-2',
  'AsS0dH8V[',
  'I$T0le;@402[60nI12',
  'A:M0wV70|',
  '^HU0U',
  'YIU0M',
  'IxK0gl90s',
  'gJU0l1',
  'ALU06',
  'QLU0N7',
  'wSU0lJ',
  ';ba0U8?',
  '2Sb0V6',
  'I]b0#4',
  '2Fe0k',
  'Aae071',
  '^SC0HE}2::MGEG.OovB2:8e#4G6G-28}2871]7$65ml1G$mEm6OGOEWE%1eE916Ou6m868W$6m6GU11OE8W91WEWGMmOG6eM$8e6W6mG611Of371136P2}18EH4M',
  '^aE0]uFq8#@^U20U%LEwSS1f7HLfkX2vCH4vM(a10gv10IO10Yg30Hz}}VE8to8-w8@J8-28tK8td8N48FC8E8l68cGNM8V#8#98lK8-A8-A8|8728E8l287N8}}#E8@N8V%8tC88V88-88lC8N18@48t38l`;Y20(>101dYk201)XQ6nUv^Xao940kAi10cv3QF40UHdXG|fe8o^40}}l3YD10c]Ak]7@19YcX4UjUT16'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_5_STROKE_RADICALS = [
  '\u7384',
  '\u7389',
  '\u74DC',
  '\u74E6',
  '\u7518',
  '\u751F',
  '\u7528',
  '\u7530',
  '\u758B',
  '\u7592',
  '\u7676',
  '\u767D',
  '\u76AE',
  '\u76BF',
  '\u76EE',
  '\u77DB',
  '\u77E2',
  '\u77F3',
  '\u793A',
  '\u79B8',
  '\u79BE',
  '\u7A74',
  '\u7ACB',
  '\u9485',
  '\u957F',
  '\u9E1F',
  '\u9F99',
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY,
  goog.i18n.CharPickerData.MSG_CP_LESS_COMMON
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_HAN_5_STROKE_RADICALS = [
  'QmU0U',
  '(mU0#U',
  'o@U0,',
  'g[U0d4',
  '2{U0k',
  'w{U0!',
  'g|U0s',
  'I}U0N48k8}2',
  'g7V0k',
  'A8V0tK',
  ';SV0k',
  'o3V0:PV4',
  '^XV0d1A;A0',
  'gZV0F4',
  '(dV0dL(mA0',
  'QzV0k',
  '^zV0d1',
  'w-S0(@20tT',
  'I5W0VBQH40P4;-506',
  'wGW0c((20',
  'IHW0dG',
  '(XW0-7',
  'wfW0#1G72Ai70',
  'YOd0@L',
  'Ald0',
  ';-f0#7',
  'IIg0E',
  'QkC0}1n.O86n1^?B2V18V3{gl1$f2u6[P1[68$$P1P16926u[[E91$6.u:2UH4|f6O|11X1[E',
  'AoG0@:;12071n^kXD6I4R1:4WnB9d[15:49lHkX.1pP5Hw]nf]^H20()109d;u101@]2%KY!10:9f.;(307k8dL8}38@88-98?8V?WdA8}S87Q8748l!8-T8#d8d28lI8FK8#12@30nQI,10w^402B20F22,50-1AQ30}b(F10V49f}3]3'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_6_STROKE_RADICALS = [
  '\u7AF9',
  '\u7C73',
  '\u7CF8',
  '\u7F36',
  '\u7F51',
  '\u7F8A',
  '\u7FBD',
  '\u8001',
  '\u800C',
  '\u8012',
  '\u8033',
  '\u807F',
  '\u8089',
  '\u81E3',
  '\u81EA',
  '\u81F3',
  '\u81FC',
  '\u820C',
  '\u821B',
  '\u821F',
  '\u826E',
  '\u8272',
  '\u8278',
  '\u864D',
  '\u866B',
  '\u8840',
  '\u884C',
  '\u8863',
  '\u897E',
  '\u9875',
  '\u9F50',
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY,
  goog.i18n.CharPickerData.MSG_CP_LESS_COMMON
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_HAN_6_STROKE_RADICALS = [
  ';jW0NY',
  ';,N0YL70;<10}B',
  'Q4X0Vc',
  'guX0V2',
  '^wX075',
  'IlV0;G20l4',
  '(*X076',
  '^;X0?',
  '^<X0c',
  'g=X0@2',
  'g@X0-6',
  'Y|X0,',
  ';^O0Y490tP8l5',
  '(UY0k',
  'YVY0!',
  'IWY0!',
  '2XY0V1',
  'gYY0N1',
  ';ZY0M',
  'IaY077',
  'YhY0M',
  '(hY0c',
  'QiY0ld8lC8taI!60H1u6.',
  'gKP0^OA0U872',
  'ImZ0lg',
  ';2a0|',
  '^3a0}1',
  '^!L0(K10IAD0tP2@50',
  '(Va071',
  '2Se0l4',
  'oBg06',
  'YmC0l2onC2Wn56XC-28U86G68M8@4jql1MemO68691Em6e6.6GO6n1Oem6P268me$6n19112Eue86WWW:168:4?v6G?%2',
  'o5E0oq10;%10VE8VH91l;P^w0S1Q0101Io3102E20XZoi10n>2;10XUPN18e]1;n30v6m6(L40vHvCX1:8;g10A{30HM}}N@X2#B8F68@D8VI8@(8NQG#L8#68t18tO8#v8Na8##8VC8#^8tt(j10wB30YE30E(870NF13#hfxd1>RT18'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_7_STROKE_RADICALS = [
  '\u5364',
  '\u898B',
  '\u89D2',
  '\u8A00',
  '\u8C37',
  '\u8C46',
  '\u8C55',
  '\u8C78',
  '\u8C9D',
  '\u8D64',
  '\u8D70',
  '\u8DB3',
  '\u8EAB',
  '\u8ECA',
  '\u8F9B',
  '\u8FB0',
  '\u8FB5',
  '\u9091',
  '\u9149',
  '\u91C6',
  '\u91CC',
  '\u9F9F',
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY,
  goog.i18n.CharPickerData.MSG_CP_LESS_COMMON
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_HAN_7_STROKE_RADICALS = [
  'w4M0(<J0',
  '^Wa0?8#3',
  'Yda074QB50',
  'oha0#b^R50e',
  'A7b0N1',
  'g8b0N1',
  ';9b073',
  '2Db0N3',
  'YGb0}88V2',
  'gYb0|',
  'oZb0}5A(40',
  'wfb0dM',
  'I$b0#2',
  '2)b07EwQ4012',
  '2|b0-1',
  '^}b0U',
  '(.O0oFD0@J',
  'YKc0tG',
  'Abc0NB',
  'gmc0c',
  '2nc0U',
  '(Ig0',
  'oaC0XE#1X*en1;}B2n5F18E8!jul186X1ev1[.mn1Gn18116P1[8m]111%1n1v1[G92G6un4kX7|v1',
  'QAE0gj40lFu-8etLO#D^DT1PL9,AY30v9]_A^60Yl10;N50Az10oi10(I80F`8M8V58Nh8lCu}}}hml3Glb8N@;820o{80|m-3n3V3u-712#9nwv3+zT16'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_8_STROKE_RADICALS = [
  '\u91D1',
  '\u9577',
  '\u9580',
  '\u961C',
  '\u96B6',
  '\u96B9',
  '\u96E8',
  '\u9751',
  '\u975E',
  '\u9C7C',
  '\u9F7F',
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY,
  goog.i18n.CharPickerData.MSG_CP_LESS_COMMON
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_HAN_8_STROKE_RADICALS = [
  'wVS0(HA0-!o_20GG',
  'Ykd0s',
  'Ild0V9',
  'Yzd0@D',
  'Y<d0E',
  'w<d0F4',
  '^@d0d9',
  'g1e071',
  'w2e0M',
  '(Xf0d9',
  ';Fg0F1',
  ';qC0!:(IvB2vf71865vl194m.uu14:1]1EWH191$H1m92v1v195X8M',
  'QTJ0l8H1F4OV68-5:ssQMR1AQ50Q>U0#88@yP2dcf1798N#8FJQn30@1^;106;y30l8f4@1P1N61OV39B!DzT1E'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_9_STROKE_RADICALS = [
  '\u9762',
  '\u9769',
  '\u97CB',
  '\u97ED',
  '\u97F3',
  '\u9801',
  '\u98A8',
  '\u98DB',
  '\u98DF',
  '\u9996',
  '\u9999',
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY,
  goog.i18n.CharPickerData.MSG_CP_LESS_COMMON
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_HAN_9_STROKE_RADICALS = [
  '23e0k',
  'w3e0-8',
  'oCe0V2',
  'wFe0c',
  'ghW06oy70F1',
  'gHe0dA',
  'wWe0V3',
  'Qbe0E',
  'wbe0@B',
  'Qse0E',
  'ose0t1',
  'wrC0?f)(AC2N1{gl1f298Ef56n8M',
  'ooH0g520-Q8!IHS1:_P32-30ARC0YA40](^b70gd807Y8lBelaW728NG91}Zv1t288-4Iz70d1mt1n1|el1H2N1'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_10_STROKE_RADICALS = [
  '\u99AC',
  '\u9AA8',
  '\u9AD8',
  '\u9ADF',
  '\u9B25',
  '\u9B2F',
  '\u9B32',
  '\u9B3C',
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY,
  goog.i18n.CharPickerData.MSG_CP_LESS_COMMON
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_HAN_10_STROKE_RADICALS = [
  'Que0VHQY106',
  'I@e0N4',
  'o_e0k',
  'I`e0N6',
  'o2f0,',
  'g3f0E',
  '(3f0,',
  'w4f0t2',
  'wsC0s^?C2Ubvl1:9nT',
  '^_J077O#9wM(1gQ10#Y]3};gl60@192l2'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_11_17_STROKE_RADICALS = [
  '\u9B5A',
  '\u9CE5',
  '\u9E75',
  '\u9E7F',
  '\u9EA5',
  '\u9EA6',
  '\u9EBB',
  '\u9EC3',
  '\u9ECD',
  '\u9ED1',
  '\u9EF9',
  '\u9EFD',
  '\u9EFE',
  '\u9F0E',
  '\u9F13',
  '\u9F20',
  '\u9F3B',
  '\u9F4A',
  '\u9F52',
  '\u9F8D',
  '\u9F9C',
  '\u9FA0',
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY,
  goog.i18n.CharPickerData.MSG_CP_LESS_COMMON
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_HAN_11_17_STROKE_RADICALS = [
  'Y7f0NQXWPh',
  'Qhf0dB87B8l59c',
  'w@f0!',
  'o[f0V3',
  '2`f08d1',
  'A`f0n1E',
  '2|f0s',
  '(|f0,',
  'w}f0M',
  'IdN0(mI0s8#2',
  'w3g0M',
  '24g08|',
  'A4g091E',
  'o5g0U',
  '26g071',
  'I7g0V2',
  'w9g0N1',
  '2Bg0c',
  '(Bg0}3',
  'AHg0E8s',
  'gIg0E',
  ';Ig0c',
  'YtC0#12hC2fYt1>yl1692H26ef66P5946H5nE.6',
  'IDK0t9$@9uNDGkoOR1fk^x102.20nDQf301=^N50;g202j30M^>90od80g320to12t!]1-H8F[GN6284075f3@394E8l2.G'
];


/**
 * Names of subcategories. Each message this array is the
 * name for the corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_OTHER = [
  goog.i18n.CharPickerData.MSG_CP_CJK_STROKES,
  goog.i18n.CharPickerData.MSG_CP_IDEOGRAPHIC_DESCRIPTION,
  goog.i18n.CharPickerData.MSG_CP_OTHER,
  goog.i18n.CharPickerData.MSG_CP_COMPATIBILITY,
  goog.i18n.CharPickerData.MSG_CP_LESS_COMMON
];


/**
 * List of characters in base88 encoding scheme. Each base88 encoded
 * charater string represents corresponding subcategory specified in
 * {@code goog.i18n.CharPickerData.subcategories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<string>}
 */
goog.i18n.CharPickerData.CHARLIST_OF_HAN_OTHER = [
  'AQC0N28M8d7H%F3',
  'oxC0|',
  'AzC0M8|8}1mmWM2iT0o|O065ms0P3MH1',
  'gMD0F3PB|%CF2[U%8#2Q+r0M',
  'Q=727K'
];


/**
 * Subcategory names. Each subarray in this array is a list of subcategory
 * names for the corresponding category specified in
 * {@code goog.i18n.CharPickerData.categories}.
 * @type {Array.<Array.<string>>}
 */
goog.i18n.CharPickerData.prototype.subcategories = [
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_SYMBOL,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_EMOJI,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_PUNCTUATION,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_NUMBER,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_FORMAT_WHITESPACE,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_MODIFIER,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_LATIN,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_OTHER_EUROPEAN_SCRIPTS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_AMERICAN_SCRIPTS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_AFRICAN_SCRIPTS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_MIDDLE_EASTERN_SCRIPTS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_SOUTH_ASIAN_SCRIPTS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_SOUTHEAST_ASIAN_SCRIPTS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HANGUL,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_OTHER_EAST_ASIAN_SCRIPTS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_1_STROKE_RADICALS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_2_STROKE_RADICALS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_3_STROKE_RADICALS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_4_STROKE_RADICALS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_5_STROKE_RADICALS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_6_STROKE_RADICALS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_7_STROKE_RADICALS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_8_STROKE_RADICALS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_9_STROKE_RADICALS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_10_STROKE_RADICALS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_11_17_STROKE_RADICALS,
  goog.i18n.CharPickerData.SUBCATEGORY_NAMES_OF_HAN_OTHER
];


/**
 * Character lists in base88 encoding scheme. Each subarray is a list of
 * base88 encoded charater strings representing corresponding subcategory
 * specified in {@code goog.i18n.CharPickerData.categories}. Encoding
 * scheme is described in {@code goog.i18n.CharListDecompressor}.
 * @type {Array.<Array.<string>>}
 */
goog.i18n.CharPickerData.prototype.charList = [
  goog.i18n.CharPickerData.CHARLIST_OF_SYMBOL,
  goog.i18n.CharPickerData.CHARLIST_OF_EMOJI,
  goog.i18n.CharPickerData.CHARLIST_OF_PUNCTUATION,
  goog.i18n.CharPickerData.CHARLIST_OF_NUMBER,
  goog.i18n.CharPickerData.CHARLIST_OF_FORMAT_WHITESPACE,
  goog.i18n.CharPickerData.CHARLIST_OF_MODIFIER,
  goog.i18n.CharPickerData.CHARLIST_OF_LATIN,
  goog.i18n.CharPickerData.CHARLIST_OF_OTHER_EUROPEAN_SCRIPTS,
  goog.i18n.CharPickerData.CHARLIST_OF_AMERICAN_SCRIPTS,
  goog.i18n.CharPickerData.CHARLIST_OF_AFRICAN_SCRIPTS,
  goog.i18n.CharPickerData.CHARLIST_OF_MIDDLE_EASTERN_SCRIPTS,
  goog.i18n.CharPickerData.CHARLIST_OF_SOUTH_ASIAN_SCRIPTS,
  goog.i18n.CharPickerData.CHARLIST_OF_SOUTHEAST_ASIAN_SCRIPTS,
  goog.i18n.CharPickerData.CHARLIST_OF_HANGUL,
  goog.i18n.CharPickerData.CHARLIST_OF_OTHER_EAST_ASIAN_SCRIPTS,
  goog.i18n.CharPickerData.CHARLIST_OF_HAN_1_STROKE_RADICALS,
  goog.i18n.CharPickerData.CHARLIST_OF_HAN_2_STROKE_RADICALS,
  goog.i18n.CharPickerData.CHARLIST_OF_HAN_3_STROKE_RADICALS,
  goog.i18n.CharPickerData.CHARLIST_OF_HAN_4_STROKE_RADICALS,
  goog.i18n.CharPickerData.CHARLIST_OF_HAN_5_STROKE_RADICALS,
  goog.i18n.CharPickerData.CHARLIST_OF_HAN_6_STROKE_RADICALS,
  goog.i18n.CharPickerData.CHARLIST_OF_HAN_7_STROKE_RADICALS,
  goog.i18n.CharPickerData.CHARLIST_OF_HAN_8_STROKE_RADICALS,
  goog.i18n.CharPickerData.CHARLIST_OF_HAN_9_STROKE_RADICALS,
  goog.i18n.CharPickerData.CHARLIST_OF_HAN_10_STROKE_RADICALS,
  goog.i18n.CharPickerData.CHARLIST_OF_HAN_11_17_STROKE_RADICALS,
  goog.i18n.CharPickerData.CHARLIST_OF_HAN_OTHER
];
